% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_regression.R
\name{coefficients}
\alias{coefficients}
\title{Define generic for coefficients}
\usage{
coefficients(object, ...)
}
\arguments{
\item{object}{The model object from which to extract coefficients.}

\item{...}{Additional arguments (ignored).}
}
\value{
A data frame of coefficients and related statistics.
}
\description{
A generic function to retrieve coefficients from model objects.
}
\examples{
# Simulate data and fit a fuzzy linear model
set.seed(123)
X_crisp <- matrix(round(runif(300, 2, 10)), nrow = 100, ncol = 3)
beta <- c(1.5, -0.8, 2.0)
Y_crisp <- round(X_crisp \%*\% beta + rnorm(100, mean = 0, sd = 1))
X_fuzzy <- fuzzify_crisp_matrix(X_crisp, spread = 1)
Y_fuzzy <- fuzzify_crisp_vector(Y_crisp, spread = 1)
object <- fuzzy_lm(X_fuzzy, Y_fuzzy, p = 3)

# Extract coefficients
coefficients(object)
}
