% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternary_diagram.R
\name{ternary_diagram}
\alias{ternary_diagram}
\title{Visualize individual tracer analysis as ternary diagrams}
\usage{
ternary_diagram(data, tracers = c(1:2), rows = 1, cols = 2, solution = NA)
}
\arguments{
\item{data}{A data frame containing the results from the individual tracer analysis function.}

\item{tracers}{A vector specifying the indices of the tracers to be displayed.}

\item{rows}{An integer specifying the number of rows in the grid of ternary diagrams.}

\item{cols}{An integer specifying the number of columns in the grid of ternary diagrams.}

\item{solution}{A vector containing an optional reference solution for visual comparison.}
}
\value{
A grid of ternary diagrams, each representing the predicted apportionments for a specific tracer. If there are three sources, the function generates one ternary triangle for each tracer. If there are four sources, the function generates six triangles for each tracer. The six triangles represent the following source combinations at their vertices:
1. (S1, S2, S3+S4)
2. (S2, S3, S1+S4)
3. (S3, S4, S1+S2)
4. (S4, S1, S2+S3)
5. (S1, S3, S2+S4)
6. (S2, S4, S1+S3)
}
\description{
This function creates ternary diagrams to visualize the results of the individual tracer analysis. Each ternary diagram represents the predicted apportionments for a specific tracer.
}
