% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-info_gain.R
\docType{data}
\name{score_info_gain}
\alias{score_info_gain}
\alias{score_gain_ratio}
\alias{score_sym_uncert}
\title{Scoring via entropy-based filters}
\format{
An object of class \code{filtro::class_score_info_gain} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.

An object of class \code{filtro::class_score_info_gain} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.

An object of class \code{filtro::class_score_info_gain} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.
}
\usage{
score_info_gain

score_gain_ratio

score_sym_uncert
}
\value{
An S7 object. The primary property of interest is in \code{results}. This
is a data frame of results that is populated by the \code{fit()} method and has
columns:
\itemize{
\item \code{name}: The name of the score (e.g., \code{info_gain}).
\item \code{score}: The estimates for each predictor.
\item \code{outcome}: The name of the outcome column.
\item \code{predictor}: The names of the predictor inputs.
}

These data are accessed using \code{object@results} (see examples below).
}
\description{
Three different information theory (entropy) scores can be computed.
}
\details{
These objects are used when either:
\itemize{
\item The predictors are numeric and the outcome is a factor/category, or
\item The predictors are factors and the outcome is numeric.
}

In either case, an entropy-based filter (via
\code{\link[FSelectorRcpp:information_gain]{FSelectorRcpp::information_gain()}}) is applied with the proper variable
roles. Depending on the chosen method, information gain, gain ratio, or
symmetrical uncertainty is computed. Larger values are associated with more
important predictors.
\subsection{Estimating the scores}{

In \pkg{filtro}, the \verb{score_*} objects define a scoring method (e.g., data
input requirements, package dependencies, etc). To compute the scores for
a specific data set, the \code{fit()} method is used. The main arguments for
these functions are:

\describe{
\item{\code{object}}{A score class object (e.g., \code{score_info_gain}).}
\item{\code{formula}}{A standard R formula with a single outcome on the right-hand side and one or more predictors (or \code{.}) on the left-hand side. The data are processed via \code{\link[stats:model.frame]{stats::model.frame()}}}
\item{\code{data}}{A data frame containing the relevant columns defined by the formula.}
\item{\code{...}}{Further arguments passed to or from other methods.}
\item{\code{case_weights}}{A quantitative vector of case weights that is the same length as the number of rows in \code{data}. The default of \code{NULL} indicates that there are no case weights.}
}
}

Missing values are removed for each predictor/outcome combination being
scored.

In cases where the underlying computations fail, the scoring proceeds
silently, and a missing value is given for the score.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)

# Entropy-based filter for classification tasks

cells_subset <- modeldata::cells |>
  dplyr::select(
    class,
    angle_ch_1,
    area_ch_1,
    avg_inten_ch_1,
    avg_inten_ch_2,
    avg_inten_ch_3
  )

# Information gain
cells_info_gain_res <- score_info_gain |>
  fit(class ~ ., data = cells_subset)
cells_info_gain_res@results

# Gain ratio
cells_gain_ratio_res <- score_gain_ratio |>
  fit(class ~ ., data = cells_subset)
cells_gain_ratio_res@results

# Symmetrical uncertainty
cells_sym_uncert_res <- score_sym_uncert |>
  fit(class ~ ., data = cells_subset)
cells_sym_uncert_res@results

# ----------------------------------------------------------------------------

# Entropy-based filter for regression tasks

ames_subset <- modeldata::ames |>
  dplyr::select(
    Sale_Price,
    MS_SubClass,
    MS_Zoning,
    Lot_Frontage,
    Lot_Area,
    Street
  )
ames_subset <- ames_subset |>
  dplyr::mutate(Sale_Price = log10(Sale_Price))

regression_task <- score_info_gain
regression_task@mode <- "regression"

ames_info_gain_regression_task_res <-
  regression_task |>
  fit(Sale_Price ~ ., data = ames_subset)
ames_info_gain_regression_task_res@results
\dontshow{\}) # examplesIf}
}
\seealso{
Other class score metrics: 
\code{\link{score_aov_pval}},
\code{\link{score_cor_pearson}},
\code{\link{score_imp_rf}},
\code{\link{score_roc_auc}},
\code{\link{score_xtab_pval_chisq}}
}
\concept{class score metrics}
\keyword{datasets}
