% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_thin}
\alias{qr_thin}
\title{Fast thin QR decomposition}
\usage{
qr_thin(X)
}
\arguments{
\item{X}{a \eqn{n\times p} matrix with \eqn{n>p}.}
}
\value{
A named list containing \describe{
\item{Q}{the Q matrix.}
\item{R}{the R matrix.}
}
}
\description{
qr_thin provides the thin QR factorization of the matrix \eqn{X\in\mathbb{R}^{n\times p}} with \eqn{n>p}. The thin QR factorization of the matrix \eqn{X} returns the matrices \eqn{Q\in\mathbb{R}^{n\times p}} and the upper triangular matrix \eqn{R\in\mathbb{R}^{p\times p}} such that \eqn{X=QR}. See Golub and Van Loan (2013) for further details on the method.
}
\examples{
## generate sample data
set.seed(1234)
n <- 12
p <- 5
X <- matrix(rnorm(n * p), n, p)

## get the thin QR factorization
output <- qr_thin(X = X)
Q      <- output$Q
R      <- output$R

## check
max(abs(Q \%*\% R - X))

}
\references{
\insertRef{golub_van_loan.2013}{fastQR}

\insertRef{bjorck.2015}{fastQR}

\insertRef{bjorck.2024}{fastQR}

\insertRef{bernardi_etal.2024}{fastQR}
}
