% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_X}
\alias{qr_X}
\title{Reconstruct the original matrix from which the object was constructed \eqn{X\in\mathbb{R}^{n\times p}} from the Q and R matrices of the QR decomposition.}
\usage{
qr_X(Q, R, pivot = NULL)
}
\arguments{
\item{Q}{either the reduced \eqn{Q\in\mathbb{R}^{n\times p}} of full \eqn{Q\in\mathbb{R}^{n\times n}}, Q matrix obtained from the QR decomposition.}

\item{R}{either the reduced \eqn{R\in\mathbb{R}^{p\times p}} of full \eqn{R\in\mathbb{R}^{n\times p}}, R matrix obtained from the QR decomposition.}

\item{pivot}{a vector of length \eqn{p}, specifying the permutation of the columns of \eqn{X} applied during the QR decomposition process. The default is NULL if no pivoting has been applied.}
}
\value{
returns the matrix \eqn{X}.
}
\description{
returns the \eqn{X\in\mathbb{R}^{n\times p}} matrix.
}
\examples{
## generate sample data
set.seed(1234)
n <- 12
p <- 5
X <- matrix(rnorm(n * p), n, p)

## get the full QR decomposition with pivot
qr_res <- fastQR::qr_fast(X = X,
                          tol = sqrt(.Machine$double.eps),
                          pivot = TRUE)

## get the full QR decomposition with pivot
qr_res <- fastQR::qr_fast(X = X, pivot = TRUE)

## get the Q and R matrices
Q  <- qr_Q(qr = qr_res$qr, tau = qr_res$qraux, rank = qr_res$rank, complete = TRUE)
R  <- qr_R(qr = qr_res$qr, rank = qr_res$rank, complete = TRUE)
X1 <- qr_X(Q = Q, R = R, pivot = qr_res$pivot)
max(abs(X1 - X))

## get the full QR decomposition without pivot
qr_res <- fastQR::qr_fast(X = X, pivot = FALSE)

## get the Q and R matrices
Q  <- qr_Q(qr = qr_res$qr, tau = qr_res$qraux, rank = p, complete = FALSE)
R  <- qr_R(qr = qr_res$qr, rank = NULL, complete = FALSE)
X1 <- qr_X(Q = Q, R = R, pivot = NULL)
max(abs(X1 - X))

}
\references{
\insertRef{golub_van_loan.2013}{fastQR}

\insertRef{bjorck.2015}{fastQR}

\insertRef{bjorck.2024}{fastQR}

\insertRef{bernardi_etal.2024}{fastQR}
}
