% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_Q}
\alias{qr_Q}
\title{Reconstruct the Q, matrix from a QR object.}
\usage{
qr_Q(qr, tau, rank = NULL, complete = NULL)
}
\arguments{
\item{qr}{object representing a QR decomposition. This will typically have come from a previous call to qr.}

\item{tau}{a vector of length \eqn{ncol(X)} which contains additional information on \eqn{Q}. It corresponds to qraux from a previous call to qr.}

\item{rank}{the rank of x as computed by the decomposition.}

\item{complete}{logical flag (length 1). Indicates whether to compute the full \eqn{Q \in \bold{R}^{n \times n}} or the thin \eqn{Q \in \bold{R}^{n \times p}}. If \eqn{r = \mathrm{rank}(X) < p}, then only the reduced \eqn{Q \in \mathbb{R}^{n \times r}} matrix is returned.}
}
\value{
returns part or all of \eqn{Q}, the order-\eqn{n} orthogonal (unitary) transformation represented by qr. If complete is TRUE, \eqn{Q} has \eqn{n} columns. If complete is FALSE, \eqn{Q} has \eqn{p} columns.
}
\description{
returns the \eqn{Q} matrix of the full QR decomposition. If \eqn{r = \mathrm{rank}(X) < p}, then only the reduced \eqn{Q \in \mathbb{R}^{n \times r}} matrix is returned.
}
\examples{
## generate sample data
set.seed(1234)
n <- 12
p <- 5
X <- matrix(rnorm(n * p), n, p)

## get the full QR decomposition with pivot
qr_res <- fastQR::qr_fast(X = X,
                          tol = sqrt(.Machine$double.eps),
                          pivot = TRUE)

## get the full Q matrix
Q1 <- qr_Q(qr_res$qr, qr_res$qraux, complete = TRUE)

## check the Q matrix (orthogonality)
max(abs(crossprod(Q1)-diag(1, n)))

## get the reduced Q matrix
Q2 <- qr_Q(qr_res$qr, qr_res$qraux, qr_res$rank, complete = FALSE)

## check the Q matrix (orthogonality)
max(abs(crossprod(Q2)-diag(1, p)))

}
\references{
\insertRef{golub_van_loan.2013}{fastQR}

\insertRef{bjorck.2015}{fastQR}

\insertRef{bjorck.2024}{fastQR}

\insertRef{bernardi_etal.2024}{fastQR}
}
