% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-fEGarch_risk.R
\name{autoplot,fEGarch_risk-method}
\alias{autoplot,fEGarch_risk-method}
\title{Plotting of Risk Measure Results (\code{ggplot2})}
\usage{
\S4method{autoplot}{fEGarch_risk}(object, which = NULL, ...)
}
\arguments{
\item{object}{an object returned by \code{measure_risk}.}

\item{which}{one of the levels of VaR and ES saved in
\code{object}, usually either \code{0.975} or \code{0.99}
by default.}

\item{...}{without use.}
}
\value{
Returns a \code{ggplot2} plot object.
}
\description{
Plot risk measure results returned by \code{measure_risk}
as a points-over-threshold plot in style of \code{ggplot2}.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2003-12-31")

egarch_spec() \%>\%
 fEGarch(rt = rt, n_test = 250) \%>\%
 predict_roll() \%>\%
 measure_risk() \%>\%
 autoplot(which = 0.99)


}
