% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zebra.R
\name{zebra}
\alias{zebra}
\title{Apply Zebra Striping to an HTML Matrix}
\usage{
zebra(x, col = c("#FFFFFF", "#CCCCCC"), byrow = TRUE)
}
\arguments{
\item{x}{An \code{html_matrix} object to which the zebra striping will be applied.}

\item{col}{A character vector of colors to use for striping. Defaults to
\code{c("#FFFFFF", "#CCCCCC")}.}

\item{byrow}{Logical; if \code{TRUE}, colors are applied to rows, otherwise
to columns. Default is \code{TRUE}.}
}
\value{
An \code{html_matrix} object with updated background colors.
}
\description{
This function applies alternating background colors (zebra striping) to an
\code{html_matrix} object, either by rows or by columns.
}
\examples{
library("magrittr")
m  <- matrix(13:24, ncol = 4)
hm <- html_matrix(m) \%>\% zebra()
html <- toHTML(hm)
if (interactive()) toHTML(hm, browser = TRUE) # opens in browser

}
