% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size.R
\name{sample_size_freq}
\alias{sample_size_freq}
\alias{dnsizefreq}
\title{Sample Size Consistency Checker}
\usage{
sample_size_freq(n, f, which = NA)

dnsizefreq(n, f, which = NA)
}
\arguments{
\item{n}{numeric: vector of sample size(s) to check}

\item{f}{numeric: vector of relative frequencies}

\item{which}{numeric: if several \code{n}'s are possible then \code{which} is returned (default: \code{NA} = choose a random one)}
}
\value{
One sample size.
}
\description{
Checks if a vector of possible sample sizes and relative frequencies create integer absolute frequencies.
}
\examples{
f <- ddiscrete(runif(5), unit=100)
sample_size_freq(seq(10, 200, 1), f)
sample_size_freq(seq(10, 200, 1), f, which=200)
}
