% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{forest_data}
\alias{forest_data}
\title{Comprehensive Forest Plot Dataset}
\format{
A data frame with 33 rows and 15 columns:
\describe{
\item{variable}{Character vector of variable names and group headers}
\item{est}{Numeric vector of effect estimates (Model 1 or single model)}
\item{lower}{Numeric vector of lower confidence limits (Model 1)}
\item{upper}{Numeric vector of upper confidence limits (Model 1)}
\item{pval}{Numeric vector of p-values (Model 1)}
\item{est_2}{Numeric vector of effect estimates for Model 2 (NA for single-model rows)}
\item{lower_2}{Numeric vector of lower confidence limits for Model 2}
\item{upper_2}{Numeric vector of upper confidence limits for Model 2}
\item{pval_2}{Numeric vector of p-values for Model 2}
\item{est_3}{Numeric vector of effect estimates for Model 3}
\item{lower_3}{Numeric vector of lower confidence limits for Model 3}
\item{upper_3}{Numeric vector of upper confidence limits for Model 3}
\item{pval_3}{Numeric vector of p-values for Model 3}
\item{n_total}{Numeric vector of total sample sizes}
\item{n_event}{Numeric vector of event counts}
\item{event_pct}{Numeric vector of event percentages}
\item{color_id}{Character vector of color group identifiers for visualization}
\item{note}{Character vector of notes and model descriptions}
}
}
\source{
Created for testing and demonstration of plot_forest() functionality.
}
\description{
A comprehensive dataset for demonstrating advanced forest plot functionality.
Contains multiple variable types (continuous, categorical, hierarchical),
multi-model comparisons, sample sizes, and color grouping information.
}
\details{
This dataset demonstrates various forest plot scenarios:
\itemize{
\item Continuous variables (Age, BMI)
\item Categorical variables with subgroups (Sex, BMI category, Treatment)
\item Multi-level hierarchical structures
\item Multi-model comparisons (Models 1-3 for last 3 rows)
\item Sample size and event information
\item Color grouping for enhanced visualizations
}
}
\keyword{datasets}
