% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_gene_id.R
\name{convert_gene_id}
\alias{convert_gene_id}
\title{convert_gene_id(): Convert gene identifiers using a reference table}
\usage{
convert_gene_id(
  query,
  from = "symbol",
  to = c("ensembl_id", "entrez_id"),
  species = c("human", "mouse"),
  query_col = NULL,
  ref_table = NULL,
  keep_na = FALSE,
  preview = TRUE
)
}
\arguments{
\item{query}{Character vector or data.frame to convert.}

\item{from}{Source ID type (e.g., "symbol", "ensembl_id", "entrez_id").}

\item{to}{Target ID type(s). Supports multiple.}

\item{species}{Either \code{"human"} or \code{"mouse"}. Default \code{"human"}.}

\item{query_col}{If \code{query} is a data.frame, the column name to convert.}

\item{ref_table}{Optional reference table.}

\item{keep_na}{Logical. Whether to keep unmatched rows. Default: \code{FALSE}.}

\item{preview}{Logical. Whether to preview output. Default: \code{TRUE}.}
}
\value{
A \code{data.frame} containing original and converted columns.
}
\description{
Converts between Ensembl, Symbol, and Entrez gene IDs using a reference table.
Supports both character vectors and data.frame columns. Automatically loads
species-specific reference data from \verb{data/}, or downloads if unavailable.
}
