% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_preport_ytd_rates}
\alias{epitrax_preport_ytd_rates}
\title{Create year-to-date (YTD) rates public report from an EpiTrax object}
\usage{
epitrax_preport_ytd_rates(epitrax)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}
}
\value{
Updated EpiTrax object with YTD rates report added to the
\code{public_reports} field.
}
\description{
\code{epitrax_preport_ytd_rates} generates a public report of year-to-date
rates for the current month in the EpiTrax object data.
}
\examples{
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
disease_lists <- list(
  internal = "use_defaults",
  public = "use_defaults"
)

epitrax <- setup_epitrax(
  filepath = data_file,
  config_file = config_file,
  disease_list_files = disease_lists
) |>
 epitrax_preport_ytd_rates()

names(epitrax$public_reports)
}
