% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{e_pie_matrix}
\alias{e_pie_matrix}
\title{Generate pie chart for matrix}
\usage{
e_pie_matrix(e, x, y, legend = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{x, y}{x and y column names for data to be used in the pie chart}

\item{legend}{Whether to add a legend, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Draw pie or donut chart in matrix coordinate system
}
\examples{

df <- data.frame("Class" = rep(c("Class1", "Class2", "Class3"),each = 3),
                   "Grade" = c("Grade1","Grade2", "Grade3"),
                  "A" = sample(1:10, 9),
                  "B" = sample(1:10,9),
                  "C" = sample(1:10,9))

df |> e_chart(x = A) |>
 e_matrix(xAxis = "Class", yAxis = "Grade") |>
 e_matrix_parent(value = "Primary", children = c("Class1", "Class2")) |>
 e_matrix_parent(value = "High", children = "Class3") |>
 e_matrix_corner(value = "All School",
   label = list(fontSize = 24, color = "#555", position = "inside")) |>
 e_pie(B, coord_system = "matrix", label = list(show = FALSE)) |>
 e_tooltip(trigger = "item") |>
 e_legend()

 df |> e_chart() |>
  e_matrix(xAxis = "Class", yAxis = "Grade") |>
  e_pie_(serie = c("A","B","C"),
   coord_system = "matrix",
     label = list(show = FALSE)) |>
  e_tooltip(trigger = "item") |>
  e_legend()

 df |> e_chart() |>
 e_matrix(xAxis = "Class", yAxis = "Grade") |>
 e_pie_matrix(x = "A", y = c( "B", "C"))

}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-pie}{Additional arguments}
}
