% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_fn.R
\name{ebnm_check_fn}
\alias{ebnm_check_fn}
\title{Check a custom ebnm function}
\usage{
ebnm_check_fn(fn, x, s)
}
\arguments{
\item{fn}{The function to be checked.}

\item{x}{A test set (vector) of observations.}

\item{s}{A test set of standard errors. Typically, ebnm-style functions
should be able to accept a vector of standard errors or a scalar if all
standard errors are identical. This is not always the case; for example,
the horseshoe prior family requires homoskedastic standard errors.}
}
\value{
Prints a success message and silently returns 1 if all checks pass.
  Otherwise the function errors out.
}
\description{
Checks inputs and outputs of an ebnm-style function. Designed to
  troubleshoot custom functions, especially those that are intended for use
  in the \code{flashier} package (e.g., as argument to the \code{ebnm_fn}
  parameter in function \code{\link[flashier]{flash}}).
}
\examples{
ebnm_check_fn(ebnm_normal, x = rnorm(10, sd = 2), s = 1)

}
