% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-validation.R
\name{validate_var_relationship}
\alias{validate_var_relationship}
\title{Validate Variable Relationship}
\usage{
validate_var_relationship(dt, var1, var2)
}
\arguments{
\item{dt}{A data.table.}

\item{var1}{Character string: name of the first variable.}

\item{var2}{Character string: name of the second variable.}
}
\value{
An S3 object of class \code{validate_var_rel} containing:
\describe{
\item{table_name}{Name of the input table from the original call}
\item{var1, var2}{Names of the variables analyzed}
\item{relation}{Character string: "one-to-one", "one-to-many",
"many-to-one", or "many-to-many"}
\item{var1_unique}{Number of distinct values in var1}
\item{var2_unique}{Number of distinct values in var2}
\item{n_combinations}{Number of unique (var1, var2) pairs}
\item{var1_has_dups}{Logical: does any var1 value map to multiple var2 values?}
\item{var2_has_dups}{Logical: does any var2 value map to multiple var1 values?}
}
}
\description{
Determines the relationship between two variables in a data.table:
one-to-one, one-to-many, many-to-one, or many-to-many.
}
\details{
This function only accepts variables of type character, integer, or factor.
Numeric (double) variables are not allowed due to potential floating-point
comparison issues.

The relationship is determined as follows:
\itemize{
\item \strong{one-to-one}: Each value of var1 maps to exactly one value of var2,
and vice versa.
\item \strong{one-to-many}: Each value of var1 maps to exactly one value of var2,
but some var2 values map to multiple var1 values.
\item \strong{many-to-one}: Some var1 values map to multiple var2 values,
but each var2 value maps to exactly one var1 value.
\item \strong{many-to-many}: Both variables have values that map to multiple
values of the other.
}
}
\examples{
library(data.table)
dt <- data.table(
  person_id = c(1L, 2L, 3L, 4L),
  department = c("Sales", "Sales", "Engineering", "Engineering"),
  country = c("US", "US", "US", "UK")
)

# Many-to-one: multiple persons per department
validate_var_relationship(dt, "person_id", "department")

# Many-to-many: departments and countries have complex mapping
validate_var_relationship(dt, "department", "country")

}
\seealso{
\code{\link[=validate_primary_keys]{validate_primary_keys()}} for key uniqueness validation,
\code{\link[=validate_join]{validate_join()}} for join relationship analysis
}
