% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{checkDivergence}
\alias{checkDivergence}
\title{Compare divergence along a tree in terms of mutations (sum of branches)
for each tip and reconstructed internal node 
to its Hamming distance from the germline. Divergence should never be less than Hamming distance. 
A threshold of -1 is used to represent 
1 full mutation difference. The function will throw a warning if any trees
cross this threshold}
\usage{
checkDivergence(
  clones,
  threshold = -1,
  verbose = TRUE,
  germline = "Germline",
  data_type = "DNA"
)
}
\arguments{
\item{clones}{a tibble of clones and trees, output from \link{getTrees}}

\item{threshold}{Minimum allowed value of divergence minus Hamming distance}

\item{verbose}{Print whether all trees passed}

\item{germline}{ID of the tree's predicted germline sequence}

\item{data_type}{The type of data being used. Either "DNA" (default) or "AA"}
}
\value{
\code{tibble} showing the clone_id, sequence_id, as well as tree-based
divergence, hamming distance, and difference between the two.
}
\description{
Compare divergence along a tree in terms of mutations (sum of branches)
for each tip and reconstructed internal node 
to its Hamming distance from the germline. Divergence should never be less than Hamming distance. 
A threshold of -1 is used to represent 
1 full mutation difference. The function will throw a warning if any trees
cross this threshold
}
