#' Landslide early warning messages during Ditwah strom in November, 2025
#'
#' A dataset containing early warning messages for landslide-prone areas, including report details, validity periods, locations, and warning levels.
#'
#' @format A data frame with the following variables:
#' \describe{
#'   \item{ID_DataAnalyst}{\code{chr}. Identifier of the data analyst }
#'   \item{Report_Date}{\code{dttm}. Date on which the landslide early warning report was issued.}
#'   \item{Report_Time}{\code{chr}. Time at which the report was issued, in HH:MM format.}
#'   \item{Message_ID}{\code{chr}. Unique identifier for each warning message. Encodes the warning type, date, time, and message sequence.}
#'   \item{Valid_From_Date}{\code{dttm}. Start date from which the warning is valid.}
#'   \item{Valid_From_Time}{\code{chr}. Start time from which the warning is valid, in HH:MM format.}
#'   \item{Valid_To_Date}{\code{dttm}. End date until which the warning remains valid.}
#'   \item{Valid_To_Time}{\code{chr}. End time until which the warning remains valid, in HH:MM format.}
#'   \item{District}{\code{chr}. Administrative district where the potential landslide risk has been identified.}
#'   \item{Location}{\code{chr}. Specific locality, town, or area within the district affected by the warning.}
#'   \item{Level}{\code{dbl}. Landslide early warning level (1 = Level 1, 2 = Level 2, 3 = Level 3). Represents the severity of the situation.}
#'   \item{State}{\code{dbl}. Direction and magnitude of the landslide (1-shifted one level up, 2-shifted two levels up, -1-shifted one level down, -2-shifted two levels down).}
#'   \item{Province}{Province}
#' }
#'
#' @source Based on land slides early warning pdf reports published by Disaster Management Centre, Sri Lanka. The data from PDF files were cleaned and processes by the package authors. Accessed from <https://www.dmc.gov.lk/index.php?option=com_dmcreports&view=reports&Itemid=276&report_type_id=5&lang=en>
"ditwah_landslides_warnings"
