##' @importFrom dplyr "%>%"

extract_important_digits <- function(val) {
  if(!is.na(val) && (val != "NA") && (as.numeric(val)!=0)) {
    val %>% gsub(".", "", ., fixed = TRUE) %>%
    gsub("-", "", ., fixed = TRUE) %>%
    stringr::str_remove(., "^0+")
  } else
    val %>% gsub(".", "", ., fixed = TRUE)
}

##' Pretty print number
##' @title prettyNumbers
##' @param vals numeric
##' @param digits how many significant digits to print
##' @return character vector of pretty printed numbers
##' @author Fabian Kück
##' @export

prettyNumbers <- function(vals, digits=5) {

  vvals <- format(vals, scientific=FALSE, digits=digits)
  vvals <- sapply(vvals, function(val) {
    if (grepl("NA", val, fixed = TRUE)) return(val)
    while (nchar(val %>% extract_important_digits) < digits) {
      if (length(grep(".", val, fixed=TRUE))>0) {
        val <- paste0(val, "0")
      } else {
        val <- paste0(val, ".0")
      }
    }
    val
  } %>% gsub(" ", "", .) )
  names(vvals) <- NULL

  vvals[grep("NA", vvals)] <- NA

  names(vvals) <- names(vals)

  return(vvals)
}
