% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_to_triples.R
\name{dataset_to_triples}
\alias{dataset_to_triples}
\title{Dataset to triples (three columns or N-Triples)}
\usage{
dataset_to_triples(x, idcol = NULL, expand_uri = TRUE, format = "data.frame")
}
\arguments{
\item{x}{A \code{dataset_df} or \code{data.frame}.}

\item{idcol}{Name or index of the subject column. If NULL, defaults to
\code{"rowid"} or rownames.}

\item{expand_uri}{Logical; if TRUE, expands URIs using namespaces and
definitions.}

\item{format}{Output format: \code{"data.frame"} (default) or \code{"nt"} for
N-Triples.}
}
\value{
Either a \code{data.frame} with columns \code{s}, \code{p}, and \code{o}, or a character
vector of N-Triple lines.
}
\description{
Converts a dataset to RDF-style triples with subject, predicate,
and object columns. Supports semantic expansion via variable metadata.
}
\details{
For publishing examples, a minimal serverless scaffold is provided at
\url{https://github.com/dataobservatory-eu/dataset-template}, which shows how
to host CSV + RDF serialisations on GitHub Pages without any server setup.
}
\note{
A simple, serverless scaffolding for publishing \code{dataset_df} objects
on the web (with HTML + RDF exports) is available at
\url{https://github.com/dataobservatory-eu/dataset-template}.
}
\examples{
# A minimal example with just rowid and geo
data("gdp", package = "dataset")
small_geo <- dataset_df(
  geo = defined(
    gdp$geo[1:3],
    label = "Geopolitical entity",
    concept = "http://example.com/prop/geo",
    namespace = "https://dd.eionet.europa.eu/vocabulary/eurostat/geo/$1"
  )
)

# View as triple table
dataset_to_triples(small_geo)

# View as N-Triples
dataset_to_triples(small_geo, format = "nt")
}
