% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_df.R
\name{dataset_df}
\alias{dataset_df}
\alias{as_dataset_df}
\alias{is.dataset_df}
\alias{print.dataset_df}
\alias{is_dataset_df}
\title{Create a new \code{dataset_df} object}
\usage{
dataset_df(
  ...,
  identifier = c(obs = "http://example.com/dataset#obs"),
  var_labels = NULL,
  units = NULL,
  concepts = NULL,
  dataset_bibentry = NULL,
  dataset_subject = NULL
)

as_dataset_df(
  df,
  identifier = c(obs = "http://example.com/dataset#obs"),
  var_labels = NULL,
  units = NULL,
  concepts = NULL,
  dataset_bibentry = NULL,
  dataset_subject = NULL,
  ...
)

is.dataset_df(x)

\method{print}{dataset_df}(x, ...)

is_dataset_df(x)
}
\arguments{
\item{...}{Vectors (columns) that should be included in the dataset.}

\item{identifier}{A named vector of one or more URI prefixes for row IDs.
Defaults to \code{c(eg = "http://example.com/dataset#")}. For example, if your
dataset will be published under DOI \verb{https://doi.org/1234}, you may use
\code{c(obs = "https://doi.org/1234#")}, which will generate row URIs such as
\verb{https://doi.org/1234#1}, ..., \verb{#n}.}

\item{var_labels}{A named list of human-readable labels for each variable.}

\item{units}{A named list of measurement units for measured variables.}

\item{concepts}{A named list of linked concepts (URIs) for variables or
dimensions.}

\item{dataset_bibentry}{A bibliographic metadata record for the dataset,
created using \code{\link[=datacite]{datacite()}} or \code{\link[=dublincore]{dublincore()}}.}

\item{dataset_subject}{A subject descriptor created with \code{\link[=subject]{subject()}} or
\code{\link[=subject_create]{subject_create()}}.}

\item{df}{A \code{data.frame} to convert to a \code{dataset_df}.}

\item{x}{A \code{dataset_df} object (used in method dispatch).}
}
\value{
A \code{dataset_df} object: a tibble with attached metadata stored in
attributes.

\code{is.dataset_df} returns a logical value
(if the object is of class \code{dataset_df}.)
}
\description{
The \code{dataset_df()} constructor creates semantically rich modern data frames.
These inherit from \code{\link[tibble:tibble]{tibble::tibble}} and carry structured metadata using
attributes.
}
\details{
Use \code{is.dataset_df()} to check class membership.

S3 methods for \code{dataset_df} include:
\itemize{
\item \code{print()} to display the dataset with metadata
\item \code{summary()} to summarize both data and metadata
}

For full details, see \code{vignette("dataset_df", package = "dataset")}.
}
\note{
A simple, serverless scaffolding for publishing \code{dataset_df} objects
on the web (with HTML + RDF exports) is available at
\url{https://github.com/dataobservatory-eu/dataset-template}.
}
\examples{
my_dataset <- dataset_df(
  country_name = defined(
    c("AD", "LI"),
    concept = "http://data.europa.eu/bna/c_6c2bb82d",
    namespace = "https://www.geonames.org/countries/$1/"
  ),
  gdp = defined(
    c(3897, 7365),
    label = "Gross Domestic Product",
    unit = "million dollars",
    concept = "http://data.europa.eu/83i/aa/GDP"
  ),
  identifier = c(
    obs = "https://dataobservatory-eu.github.io/dataset-template#"
  ),
  dataset_bibentry = dublincore(
    title = "GDP of Andorra and Liechtenstein",
    description = "A small but semantically rich dataset example.",
    creator = person("Jane", "Doe", role = "cre"),
    publisher = "Open Data Institute",
    language = "en"
  )
)

# Basic usage
print(my_dataset)
head(my_dataset)
summary(my_dataset)

# Metadata access
as_dublincore(my_dataset)
as_datacite(my_dataset)

# Export description as RDF triples
my_description <- describe(my_dataset, con = tempfile())
my_description

}
\seealso{
\code{\link[=defined]{defined()}}, \code{\link[=dublincore]{dublincore()}}, \code{\link[=datacite]{datacite()}}, \code{\link[=subject]{subject()}}
}
