% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibrecord.R
\name{bibrecord}
\alias{bibrecord}
\title{Create a Modern Metadata Object Compatible with bibentry}
\usage{
bibrecord(
  title,
  author,
  contributor = NULL,
  publisher = NULL,
  year = NULL,
  date = Sys.Date(),
  identifier = NULL,
  subject = NULL,
  ...
)
}
\arguments{
\item{title}{A character string specifying the dataset title.}

\item{author}{A \code{\link[utils:person]{utils::person()}} or list/vector of person objects. Mapped to
\code{creator} in DataCite and DCMI.}

\item{contributor}{Optional list or vector of \code{\link[utils:person]{utils::person()}} objects.
Contributor roles are merged if duplicated.}

\item{publisher}{A character string or \code{\link[utils:person]{utils::person()}} representing the
publishing entity.}

\item{year}{Publication year. Automatically derived from \code{date} if not
provided explicitly.}

\item{date}{A \link{Date} object or character string in ISO format.}

\item{identifier}{A persistent identifier (e.g., DOI or URL).}

\item{subject}{Optional keyword, tag, or controlled vocabulary term.}

\item{...}{Additional fields such as \code{language}, \code{format}, \code{rights}, or
\code{description}.}
}
\value{
An object of class \code{"bibrecord"} and \code{"bibentry"}, suitable for citation and
embedding in metadata-aware structures such as \code{\link[=dataset_df]{dataset_df()}}.
}
\description{
Constructs a \code{\link[utils:bibentry]{utils::bibentry()}} object extended with Dublin Core and
DataCite-compatible fields. This unified structure supports use with
functions such as \code{\link[=dublincore]{dublincore()}} and \code{\link[=datacite]{datacite()}}, and is the internal
format for storing rich metadata with datasets.
}
\examples{
bibrecord(
  title = "Gross domestic product, volumes",
  author = person("Eurosat"),
  publisher = person("Eurostat"),
  identifier = "https://doi.org/10.2908/TEINA011",
  date = as.Date("2025-05-20")
)

}
\seealso{
Learn more in the vignette:
\href{https://dataset.dataobservatory.eu/articles/bibrecord.html}{\code{bibrecord}}

Other bibrecord functions: 
\code{\link{as_datacite}()},
\code{\link{as_dublincore}()}
}
\concept{bibrecord functions}
