% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rights.R
\name{rights}
\alias{rights}
\alias{rights<-}
\title{Get or Set the Rights of a Dataset Object}
\usage{
rights(x)

rights(x, overwrite = FALSE) <- value
}
\arguments{
\item{x}{A semantically rich data frame created with \code{\link[=dataset_df]{dataset_df()}} or
\code{\link[=as_dataset_df]{as_dataset_df()}}.}

\item{overwrite}{Logical. Should the existing value be replaced? If \code{FALSE}
and a value already exists, the function emits a message instead of
overwriting. Defaults to \code{FALSE}.}

\item{value}{A character string specifying the rights (e.g., \code{"CC-BY-4.0"}).}
}
\value{
The \code{"rights"} attribute of the dataset as a character string (length 1).
When assigning, the updated object \code{x} is returned invisibly.
}
\description{
Adds or retrieves the optional \code{"rights"} attribute of a dataset object.
This field contains information about intellectual property or usage rights.
}
\details{
The \code{"rights"} field corresponds to
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/rights/}{dct:rights}
from Dublin Core, and to \code{rights} in \href{https://schema.datacite.org/}{DataCite}.

Rights information typically includes statements about legal ownership,
licensing, or usage conditions. It helps ensure that users understand how
a dataset may be reused, cited, or shared.
}
\examples{
rights(orange_df) <- "CC-BY-SA"
rights(orange_df)

}
\seealso{
Other bibliographic helper functions: 
\code{\link{contributor}()},
\code{\link{creator}()},
\code{\link{dataset_format}()},
\code{\link{dataset_title}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{get_bibentry}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{relation}()},
\code{\link{subject}()}
}
\concept{bibliographic helper functions}
