% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blueprints.R
\name{GetBlueprint}
\alias{GetBlueprint}
\title{Retrieve a blueprint}
\usage{
GetBlueprint(project, blueprintId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{blueprintId}{character. Id of blueprint to retrieve.}
}
\value{
List with the following four components:
\describe{
  \item{projectId}{Character string giving the unique DataRobot project identifier}
  \item{processes}{List of character strings, identifying any preprocessing steps included in the
  blueprint}
  \item{blueprintId}{Character string giving the unique DataRobot blueprint identifier}
  \item{modelType}{Character string, specifying the type of model the blueprint builds}
  \item{blueprintCategory}{Character string. Describes the category of the blueprint
  and the kind of model it produces.}
}
}
\description{
Retrieve a blueprint
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  blueprintId <- model$blueprintId
  GetBlueprint(projectId, blueprintId)
}
}
