% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tennis.int}
\alias{tennis.int}
\title{Tennis Court Types Interval Dataset}
\format{
A data frame with 4 observations and 4 variables:
\itemize{
    \item \code{court_type}: Type of court (Hard, Grass, Indoor, Clay).
    \item \code{player_weight}: Player weight range (kg).
    \item \code{player_height}: Player height range (m).
    \item \code{racket_tension}: Racket tension range.
}
}
\usage{
data(tennis.int)
}
\description{
Interval-valued data for tennis players aggregated by court type
(Hard, Grass, Indoor, Clay) with weight, height, and racket tension.
}
\details{
Clustering on weight and height separates grass courts from the rest
(decision rule: Weight <= 74.75 kg). When all three variables are used,
clustering separates by racket tension instead.
}
\examples{
data(tennis.int)
}
\references{
Billard, L. and Diday, E. (2006). \emph{Symbolic Data Analysis}. Wiley.
Table 2.25, p.64.
}
\keyword{clustering}
\keyword{datasets}
\keyword{interval}
