% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_similarity.R
\name{interval_similarity}
\alias{interval_similarity}
\alias{int_jaccard}
\alias{int_dice}
\alias{int_cosine}
\alias{int_overlap_coefficient}
\alias{int_tanimoto}
\alias{int_similarity_matrix}
\title{Similarity Measures for Interval Data}
\usage{
int_jaccard(x, var_name1, var_name2, ...)

int_dice(x, var_name1, var_name2, ...)

int_cosine(x, var_name1, var_name2, ...)

int_overlap_coefficient(x, var_name1, var_name2, ...)

int_tanimoto(x, var_name1, var_name2, ...)

int_similarity_matrix(x, method = "jaccard", ...)
}
\arguments{
\item{x}{interval-valued data with symbolic_tbl class.}

\item{var_name1}{the first variable name or column location.}

\item{var_name2}{the second variable name or column location.}

\item{...}{additional parameters}

\item{method}{similarity method for int_similarity_matrix: "jaccard", "dice", or "overlap".}
}
\value{
A numeric matrix or value
}
\description{
Functions to compute similarity measures between interval-valued observations.
}
\details{
These functions compute various similarity measures:
\itemize{
  \item \code{int_jaccard}: Jaccard similarity coefficient
  \item \code{int_dice}: Dice similarity coefficient
  \item \code{int_cosine}: Cosine similarity
  \item \code{int_overlap_coefficient}: Overlap coefficient
  \item \code{int_tanimoto}: Tanimoto coefficient (generalized Jaccard)
}

All similarity measures range from 0 (no similarity) to 1 (perfect similarity).
}
\examples{
data(mushroom.int)

# Jaccard similarity
int_jaccard(mushroom.int, "Pileus.Cap.Width", "Stipe.Length")

# Dice coefficient
int_dice(mushroom.int, 2, 3)

# Cosine similarity
int_cosine(mushroom.int, 
           var_name1 = c("Pileus.Cap.Width"), 
           var_name2 = c("Stipe.Length", "Stipe.Thickness"))

# Overlap coefficient
int_overlap_coefficient(mushroom.int, 2, 3:4)
}
\seealso{
int_dist int_cor int_jaccard
}
\author{
Han-Ming Wu
}
