% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tox_data.R
\name{td2cs}
\alias{td2cs}
\title{Create \emph{calisets} from \emph{tox_data}}
\usage{
td2cs(scenario, data, output_var = NULL)
}
\arguments{
\item{scenario}{a base \link{scenario}}

\item{data}{return value of \code{\link[=tox_data]{tox_data()}}}

\item{output_var}{optional \emph{character}, rename observed data column to this value}
}
\value{
list of \link{caliset}s
}
\description{
This is a convenience function which eases the creation of \link{caliset}s
from a base scenario and a \link{tox_data} object. The scenario
will be used as is. If exposure series are defined by the \code{tox_data}
object, then these will be assigned to the scenario(s) accordingly.
}
\examples{
# Import trial data from Schmitt et al. (2013), including exposure
mydata <- tox_data(schmitt2013)

# Example trial contained in data set: trial 'T0.32'
mydata@data[["T0.32"]]        # observed quantities
mydata@exposure[["T0.32"]]    # associated exposure series

# Create list of calisets from full data set
lst <- td2cs(Lemna_SETAC(), mydata)

# Example caliset representing conditions of trial 'T0.32'
lst[[2]]
}
