% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debt.R
\name{flag_covenants}
\alias{flag_covenants}
\title{Covenant flags after computing credit ratios}
\usage{
flag_covenants(cf, cov)
}
\arguments{
\item{cf}{A data.frame or tibble containing at least \code{dscr},
\code{ltv_forward}, and \code{debt_yield_current}.}

\item{cov}{A list of covenant thresholds. Supported elements include:
\itemize{
\item \code{dscr_min} numeric, default 1.25,
\item \code{ltv_max} numeric in \code{[0, 1]}, default 0.65,
\item \code{debt_yield_min} numeric, default 0.08.
}}
}
\value{
The input table \code{cf} enriched with logical columns
\code{cov_dscr_breach}, \code{cov_ltv_breach}, and \code{cov_dy_breach}.
}
\description{
Adds logical indicator columns for covenant breaches based on three ratios:
debt service coverage ratio (DSCR), forward loan-to-value ratio (LTV), and
current debt yield.
}
\examples{
cf <- tibble::tibble(
  year = 1:3,
  dscr = c(1.40, 1.10, NA),
  ltv_forward = c(0.60, 0.70, 0.64),
  debt_yield_current = c(0.09, 0.07, 0.08)
)
cov <- list(dscr_min = 1.25, ltv_max = 0.65, debt_yield_min = 0.08)
flag_covenants(cf, cov)

}
