% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{is_mle_numerical}
\alias{is_mle_numerical}
\title{Check if object is an mle_numerical}
\usage{
is_mle_numerical(x)
}
\arguments{
\item{x}{Object to test}
}
\value{
Logical indicating whether \code{x} inherits from \code{mle_numerical}.
}
\description{
Check if object is an mle_numerical
}
\examples{
\donttest{
problem <- mle_problem(
  loglike = function(theta) -sum((theta - c(1, 2))^2)
)
result <- gradient_ascent(max_iter = 20)(problem, c(0, 0))
is_mle_numerical(result)  # TRUE
is_mle_numerical(list())  # FALSE
}
}
