% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv.R
\name{deriv_irr}
\alias{deriv_irr}
\title{First derivative for an irregular grid}
\usage{
deriv_irr(x0, x, f)
}
\arguments{
\item{x0}{A vector of real numbers. These are the values 
where the first derivative needs to be calculated. These 
values need to be within the interval defined by the 
tabulated grid, \code{x}.}

\item{x}{A vector of real numbers. Grid points corresponding 
to the tabulated (known) values of the function.}

\item{f}{A vector of real numbers. Tabulated (known) values 
of the function, corresponding to the grid \code{x}.}
}
\value{
A vector of real numbers. These are the numeric 
approximations to the first derivative of the function at
all values in \code{x0}. The first derivative is exact when
the function is a polynomial of degree \eqn{n}, where
\eqn{n} is less than the number of tabulated values.
}
\description{
Computes the first derivative at a given point, for a function
known only through its values tabulated on an irregular grid,
where the distance between successive points of the variable
is in general not constant. The algorithm is based on the
divided differences (see \code{\link{divdif}}).
}
\details{
This numerical derivative should be used only when the 
function is known at specific points. When the analytic form
of the function is available and the grid of values of the
independent variable can be arbitrarily chosen, then it is
better to compute the derivative using other more appropriate
and faster methods.
}
\examples{
# Tabulated values: f(x) = 2*x^2-1
x <- c(0,1,3,7)
f <- 2*x^2-1

# The derivative needs to be computed at three values
x0 <- c(1.1,4,6.5)

# First derivatives
f1 <- deriv_irr(x0,x,f)
print(f1)

}
