% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kgcm.R
\name{kgcm}
\alias{kgcm}
\title{Kernel generalised covariance measure test}
\usage{
kgcm(
  Y,
  X,
  Z,
  reg_YonZ = "rf",
  reg_XonZ = "rf",
  args_YonZ = NULL,
  args_XonZ = NULL,
  B = 499L,
  return_fitted_models = FALSE,
  multivariate = c("none", "XonZ"),
  bandwidth = NULL,
  ...
)
}
\arguments{
\item{Y}{Vector of response values.}

\item{X}{Matrix or data.frame of covariates.}

\item{Z}{Matrix or data.frame of covariates.}

\item{reg_YonZ}{Character string or function specifying the regression for
Y on Z. See \code{?\link[comets]{regressions}} for more detail.}

\item{reg_XonZ}{Character string or function specifying the regression for
X on Z. See \code{?\link[comets]{regressions}} for more detail.}

\item{args_YonZ}{A list of named arguments passed to \code{reg_YonZ}.}

\item{args_XonZ}{A list of named arguments passed to \code{reg_XonZ}.}

\item{B}{Number of wild bootstrap samples.}

\item{return_fitted_models}{Logical; whether to return the fitted regressions
(default is \code{FALSE}).}

\item{multivariate}{Character; specifying which regression can handle
multivariate outcomes (\code{"none"}, or \code{"XonZ"}).
If \code{"none"}, then the regression is run using each column in X as
the response.}

\item{bandwidth}{Numeric; value of the bandwidth for the Gaussian kernel.
Defaults to \code{NULL}, corresponding to the median heuristic.}

\item{...}{Currently ignored}
}
\value{
Object of class '\code{kgcm}' and '\code{htest}' with the following
components:
\item{\code{statistic}}{The value of the test statistic.}
\item{\code{p.value}}{The p-value for the \code{hypothesis}}
\item{\code{parameter}}{In case X is multidimensional, this is the degrees of
    freedom used for the chi-squared test.}
\item{\code{hypothesis}}{String specifying the null hypothesis.}
\item{\code{null.value}}{String specifying the null hypothesis.}
\item{\code{method}}{The string \code{"Generalised covariance measure test"}.}
\item{\code{data.name}}{A character string giving the name(s) of the data.}
\item{\code{rY}}{Residuals for the Y on Z regression.}
\item{\code{rX}}{Residuals for the X on Z regression.}
\item{\code{models}}{List of fitted regressions if \code{return_fitted_models} is \code{TRUE}.}
}
\description{
Kernel generalised covariance measure test
}
\details{
The kernelized generalised covariance measure test tests whether the weighted
conditional covariance of Y and X given Z is zero.
}
\examples{
n <- 1e2
X <- matrix(rnorm(2 * n), ncol = 2)
colnames(X) <- c("X1", "X2")
Z <- matrix(rnorm(2 * n), ncol = 2)
colnames(Z) <- c("Z1", "Z2")
Y <- X[, 2]^2 + Z[, 2] + rnorm(n)
(gcm1 <- kgcm(Y, X, Z))

}
\references{
Fernández, T., & Rivera, N. (2024). A general framework for the analysis of
kernel-based tests. Journal of Machine Learning Research, 25(95), 1-40.
}
