% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.conceptMap.R
\name{print.conceptMap}
\alias{print.conceptMap}
\title{Print a Concept Map Object}
\usage{
\method{print}{conceptMap}(x, whichCluster = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{"conceptMap"} containing the results of concept mapping analysis
creating using the function \code{\link[cmAnalysis]{conceptMapping}}.}

\item{whichCluster}{A vector of cluster numbers to display. If \code{NULL} (default), all clusters are displayed.}

\item{...}{arguments to be passed to methods}
}
\value{
This function does not return a value; it prints the details of the concept map to the console.
}
\description{
This function prints a detailed summary of a concept map object, including information about
statements, sorters, clusters, and the specific statements within selected clusters.
}
\details{
The function first checks if the input object is of class \code{"conceptMap"} and validates the
requested clusters (if specified). It provides an overview of the number of statements, sorters,
and clusters. For each requested cluster, the function lists the statements included in that cluster.
}
\examples{
# Simulate data with custom parameters:
set.seed(1)
myCMData <- simulateCardData(nSorters=40, pCorrect=.90, attributeWeights=c(1,1,1,1))

# Subject the data to sorter cluster analysis
myCMDataBySorters <- sorterMapping(myCMData)

# Subject sorter cluster 3 to concept mapping using default "network" method
myCMAnalysis3 <- conceptMapping(myCMDataBySorters[[3]])

# Print content of concept map of sorter cluster 3
print(myCMAnalysis3)

}
