\name{steinhart_ahf_model}
\alias{steinhart_ahf_model}
\title{
Steinhart Model for Acute Heart Failure (AHF)
}
\description{
Calculates the post-test probability of Acute Heart Failure in patients presenting with undifferentiated dyspnea. The model integrates the clinician's pre-test probability assessment with patient age and NT-proBNP levels to improve diagnostic accuracy.
}
\usage{
steinhart_ahf_model(age, pretest_probability_percent, nt_probnp_pg_ml)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{pretest_probability_percent}{
Numeric. Clinician's estimated pre-test probability of AHF (0-100\%), based on history, physical exam, ECG, and chest X-ray, before NT-proBNP results are known.
}
  \item{nt_probnp_pg_ml}{
Numeric. Serum N-terminal pro-B-type natriuretic peptide level in pg/mL.
}
}
\value{
A list containing:
\item{PostTest_Probability}{The calculated probability of AHF diagnosis.}
\item{Interpretation}{Risk categorization (Low <= 20\%, Intermediate 21-79\%, High >= 80\%).}
}
\references{
Steinhart B, Thorpe KE, Bayoumi AM, et al. Improving the diagnosis of acute heart failure using a validated prediction model. J Am Coll Cardiol. 2012;60(16):1532-1539. doi:10.1016/j.jacc.2012.06.038
}
\examples{

# Example 1: High Probability
# 75yo, Pretest 60%, NT-proBNP 4000
steinhart_ahf_model(75, 60, 4000)

# Example 2: Low Probability
# 50yo, Pretest 20%, NT-proBNP 100
steinhart_ahf_model(50, 20, 100)
}
