\name{rome_iv_child_colic}
\alias{rome_iv_child_colic}
\title{
Rome IV Diagnostic Criteria for Infant Colic
}
\description{
Evaluates the Rome IV criteria for diagnosing **Infant Colic**, a functional gastrointestinal disorder of early infancy. Diagnosis requires recurrent, prolonged periods of crying, fussing, or irritability without any apparent cause, typically peaking at 6 weeks and resolving by 5 months of age.
}
\usage{
rome_iv_child_colic(crying_duration_hours, fussiness_duration_hours,
                    days_per_week_frequency, symptom_onset_age,
                    symptom_resolution_age, other_causes_excluded)
}
\arguments{
  \item{crying_duration_hours}{
Numeric. Average duration of crying in hours per day.
}
  \item{fussiness_duration_hours}{
Numeric. Average duration of fussiness in hours per day. **Total crying + fussing must be >= 3 hours/day.**
}
  \item{days_per_week_frequency}{
Numeric. Number of days per week the crying/fussing occurs. **Must be >= 3 days/week.**
}
  \item{symptom_onset_age}{
Numeric. Age of symptom onset in months. **Must start and resolve before 5 months of age.**
}
  \item{symptom_resolution_age}{
Numeric. Age of symptom resolution in months.
}
  \item{other_causes_excluded}{
Numeric (0 or 1). Have failure to thrive, fever, or other physical causes of crying been ruled out? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Infant Colic" or "Criteria Not Met".}
}
\references{
Zeevenhooven J, Browne PD, Huertas-Ceballos AA. Definition of infant colic: a systematic review and modified Delphi approach. Acta Paediatr. 2018;107(7):1155-1160.
Rome Foundation. Functional Gastrointestinal Disorders: Children and Adolescents. Gastroenterology. 2016.
}
\examples{

# Example 1: Diagnosis Met (Wessel's rule equivalent)
# 2 hours crying + 1 hour fussing = 3 hours. 4 days/week. Onset 1 month, resolved 4 months.
rome_iv_child_colic(2, 1, 4, 1, 4, 1)

# Example 2: Not Met (Insufficient frequency)
# 4 hours per day, but only 2 days/week
rome_iv_child_colic(4, 0, 2, 1, 4, 1)
}
