\name{revised_iss_multiple_myeloma}
\alias{revised_iss_multiple_myeloma}
\title{
Revised International Staging System (R-ISS) for Multiple Myeloma
}
\description{
Calculates the Revised International Staging System (R-ISS) for multiple myeloma. This system combines the original ISS (serum beta-2 microglobulin and albumin) with chromosomal abnormalities (CA) detected by iFISH and serum lactate dehydrogenase (LDH) levels to improve prognostic stratification.
}
\usage{
revised_iss_multiple_myeloma(beta2_microglobulin, albumin, ldh_elevated,
                             high_risk_chromosomal_abnormalities)
}
\arguments{
  \item{beta2_microglobulin}{
Numeric. Serum Beta-2 Microglobulin level in mg/L.
}
  \item{albumin}{
Numeric. Serum Albumin level in g/dL.
}
  \item{ldh_elevated}{
Numeric (0 or 1). Is serum LDH greater than the upper limit of normal? (1 = Yes).
}
  \item{high_risk_chromosomal_abnormalities}{
Numeric (0 or 1). Presence of high-risk chromosomal abnormalities by iFISH (del(17p), t(4;14), or t(14;16)). (1 = Yes).
}
}
\details{
\strong{Staging Criteria:}
\itemize{
  \item \strong{R-ISS I}: ISS Stage I (B2M < 3.5 and Alb >= 3.5) AND No High Risk CA AND Normal LDH.
  \item \strong{R-ISS III}: ISS Stage III (B2M >= 5.5) AND (High Risk CA OR High LDH).
  \item \strong{R-ISS II}: Not R-ISS I or III.
}
}
\value{
A list containing:
\item{R_ISS_Stage}{The calculated R-ISS Stage (I, II, or III).}
\item{ISS_Stage_Calculated}{The underlying standard ISS stage.}
\item{Median_Overall_Survival}{Estimated median overall survival.}
\item{Five_Year_Survival}{Estimated 5-year overall survival rate.}
}
\references{
Palumbo A, Avet-Loiseau H, Oliva S, et al. Revised International Staging System for Multiple Myeloma: A Report From International Myeloma Working Group. J Clin Oncol. 2015;33(26):2863-2869. doi:10.1200/JCO.2015.61.2267
}
\examples{

# Example 1: R-ISS Stage I
# B2M 2.0, Alb 4.0 (ISS I), Normal LDH, No High Risk CA
revised_iss_multiple_myeloma(2.0, 4.0, 0, 0)

# Example 2: R-ISS Stage III
# B2M 6.0 (ISS III), High LDH
revised_iss_multiple_myeloma(6.0, 3.0, 1, 0)

# Example 3: R-ISS Stage II
# B2M 2.0, Alb 4.0 (ISS I), but High LDH (Disqualifies R-ISS I)
revised_iss_multiple_myeloma(2.0, 4.0, 1, 0)
}
