\name{primacy_cardiomyopathy_score}
\alias{primacy_cardiomyopathy_score}
\title{
PRIMACY Score for Dilated Cardiomyopathy Genetic Yield
}
\description{
Calculates the PRIMACY (Precision Medicine Study in Cardiomyopathy) score to predict the probability of identifying a pathogenic or likely pathogenic genetic variant in patients with Dilated Cardiomyopathy (DCM). The score utilizes clinical, electrocardiographic, and imaging features to stratify the yield of genetic testing.
}
\usage{
primacy_cardiomyopathy_score(sex, age_at_diagnosis, skeletal_myopathy,
                             family_history_dcm, low_qrs_voltage,
                             conduction_defect, lge_on_cmr)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{age_at_diagnosis}{
Numeric. Age at the time of DCM diagnosis in years.
}
  \item{skeletal_myopathy}{
Numeric (0 or 1). Presence of clinical skeletal myopathy (e.g., muscle weakness, elevated CK not explained by other causes). (1 = Yes).
}
  \item{family_history_dcm}{
Numeric (0 or 1). Family history of DCM in a first- or second-degree relative. (1 = Yes).
}
  \item{low_qrs_voltage}{
Numeric (0 or 1). Presence of low QRS voltage on ECG (typically < 0.5 mV in limb leads). (1 = Yes).
}
  \item{conduction_defect}{
Numeric (0 or 1). Presence of cardiac conduction system disease (e.g., AV block, LBBB, RBBB). (1 = Yes).
}
  \item{lge_on_cmr}{
Numeric (0 or 1). Presence of Late Gadolinium Enhancement (LGE) on Cardiac MRI. (1 = Yes).
}
}
\value{
A list containing:
\item{PRIMACY_Probability}{The estimated percentage probability of a positive genetic test result.}
\item{Interpretation}{General risk categorization (Low, Intermediate, High).}
}
\references{
Mazzarotto F, et al. Reevaluating the Genetic Architecture of Dilated Cardiomyopathy: The Precision Medicine Study in Cardiomyopathy (PRIMACY). Circulation. 2020;141(6):387-398. doi:10.1161/CIRCULATIONAHA.119.041603
}
\examples{
# Example 1: High Yield
# Female, 30yo, Family Hx, LGE present
primacy_cardiomyopathy_score("female", 30, 0, 1, 0, 0, 1)

# Example 2: Low Yield
# Male, 65yo, No other risk factors
primacy_cardiomyopathy_score("male", 65, 0, 0, 0, 0, 0)
}
