\name{painad_score}
\alias{painad_score}
\title{
Pain Assessment in Advanced Dementia (PAINAD) Scale
}
\description{
Calculates the PAINAD score, a tool designed to assess pain in patients with advanced dementia who cannot verbally communicate. The scale evaluates five behaviors: breathing, negative vocalization, facial expression, body language, and consolability. Each item is scored from 0 to 2, yielding a total score ranging from 0 to 10.
}
\usage{
painad_score(breathing, negative_vocalization, facial_expression,
             body_language, consolability)
}
\arguments{
  \item{breathing}{
Numeric (0-2). 0: Normal; 1: Occasional labored breathing/short hyperventilation; 2: Noisy labored breathing/long hyperventilation/Cheyne-Stokes.
}
  \item{negative_vocalization}{
Numeric (0-2). 0: None; 1: Occasional moan/groan/low-level negative speech; 2: Repeated troubled calling out/loud moaning/crying.
}
  \item{facial_expression}{
Numeric (0-2). 0: Smiling/inexpressive; 1: Sad/frightened/frown; 2: Facial grimacing.
}
  \item{body_language}{
Numeric (0-2). 0: Relaxed; 1: Tense/distressed pacing/fidgeting; 2: Rigid/fists clenched/knees pulled up/striking out.
}
  \item{consolability}{
Numeric (0-2). 0: No need to console; 1: Distracted/reassured by voice/touch; 2: Unable to console/distract/reassure.
}
}
\value{
A list containing:
\item{PAINAD_Score}{The calculated total score (Range 0-10).}
\item{Severity}{Interpretation of pain severity (No Pain, Mild, Moderate, Severe).}
}
\references{
Warden V, Hurley AC, Volicer L. Development and psychometric evaluation of the Pain Assessment in Advanced Dementia (PAINAD) scale. J Am Med Dir Assoc. 2003;4(1):9-15. doi:10.1093/geront/43.suppl_1.9
}
\examples{

# Example 1: Moderate Pain
# Labored breathing (1), Moaning (1), Frown (1), Tense (1), Distractible (1)
# Score = 5
painad_score(1, 1, 1, 1, 1)

# Example 2: Severe Pain
# Noisy breathing (2), Crying (2), Grimacing (2), Rigid (2), Unable to console (2)
# Score = 10
painad_score(2, 2, 2, 2, 2)
}
