\name{mgfa_classification}
\alias{mgfa_classification}
\title{
Myasthenia Gravis Foundation of America (MGFA) Clinical Classification
}
\description{
Determines the MGFA Clinical Classification for patients with Myasthenia Gravis. This system categorizes patients based on the distribution and severity of muscle weakness (ocular vs. generalized) and the specific muscle groups primarily affected (limb/axial vs. oropharyngeal/respiratory).
}
\usage{
mgfa_classification(intubated, ocular_weakness_only, generalized_severity,
                    predominant_symptoms)
}
\arguments{
  \item{intubated}{
Numeric (0 or 1). Is the patient currently intubated (excluding routine postoperative management)? (1 = Yes). This defines Class V.
}
  \item{ocular_weakness_only}{
Numeric (0 or 1). Is weakness restricted ONLY to ocular muscles (including eye closure)? (1 = Yes). This defines Class I.
}
  \item{generalized_severity}{
String. Severity of weakness affecting non-ocular muscles. Options: "mild" (Class II), "moderate" (Class III), "severe" (Class IV). Required if ocular_weakness_only is 0.
}
  \item{predominant_symptoms}{
String. The muscle groups primarily affected.
"limb_axial": Predominantly limb and/or axial muscles (Subtype a).
"oropharyngeal_respiratory": Predominantly oropharyngeal and/or respiratory muscles (Subtype b).
}
}
\value{
A list containing:
\item{MGFA_Class}{The determined classification (e.g., Class I, Class IIa, Class IVb, Class V).}
\item{Description}{The clinical definition of the classification.}
}
\references{
Jaretzki A 3rd, Barohn RJ, Ernstoff RM, et al. Myasthenia gravis: recommendations for clinical research standards. Task Force of the Medical Scientific Advisory Board of the Myasthenia Gravis Foundation of America. Neurology. 2000;55(1):16-23. doi:10.1212/wnl.55.1.16
}
\examples{

# Example 1: Mild Generalized, Limb Predominant
mgfa_classification(0, 0, "mild", "limb_axial")

# Example 2: Severe Bulbar Symptoms
mgfa_classification(0, 0, "severe", "oropharyngeal_respiratory")

# Example 3: Ocular Myasthenia
mgfa_classification(0, 1, "none", "none")
}
