% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{tables_list_columns}
\alias{tables_list_columns}
\title{List columns in the specified table}
\usage{
tables_list_columns(
  id,
  name = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{id}{integer required.}

\item{name}{string optional. Search for columns with the given name, within the specified table.}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to name. Must be one of: name, order.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{name}{string, Name of the column.}
\item{civisDataType}{string, The generic data type of the column (ex. "string"). Since this is database-agnostic, it may be helpful when loading data to R/Python.}
\item{sqlType}{string, The database-specific SQL type of the column (ex. "varchar(30)").}
\item{sampleValues}{array, A sample of values from the column.}
\item{encoding}{string, The compression encoding for this columnSee: http://docs.aws.amazon.com/redshift/latest/dg/c_Compression_encodings.html}
\item{description}{string, The description of the column, as specified by the table owner}
\item{order}{integer, Relative position of the column in the table.}
\item{minValue}{string, Smallest value in the column.}
\item{maxValue}{string, Largest value in the column.}
\item{avgValue}{number, This parameter is deprecated.}
\item{stddev}{number, This parameter is deprecated.}
\item{valueDistributionPercent}{list, A mapping between each value in the column and the percentage of rows with that value.Only present for tables with fewer than approximately 25,000,000 rows and for columns with fewer than twenty distinct values.}
\item{coverageCount}{integer, Number of non-null values in the column.}
\item{nullCount}{integer, Number of null values in the column.}
\item{possibleDependentVariableTypes}{array, Possible dependent variable types the column may be used to model.  Null if it may not be used as a dependent variable.}
\item{useableAsIndependentVariable}{boolean, Whether the column may be used as an independent variable to train a model.}
\item{useableAsPrimaryKey}{boolean, Whether the column may be used as an primary key to identify table rows.}
\item{valueDistribution}{list, An object mapping distinct values in the column to the number of times they appear in the column}
\item{distinctCount}{integer, Number of distinct values in the column. NULL values are counted and treated as a single distinct value.}
}
\description{
List columns in the specified table
}
