% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_effects.R
\name{choice_effects}
\alias{choice_effects}
\alias{print.choice_effects}
\title{Define choice model effects}
\usage{
choice_effects(
  choice_formula,
  choice_alternatives,
  choice_data = NULL,
  delimiter = "_"
)

\method{print}{choice_effects}(x, ...)
}
\arguments{
\item{choice_formula}{[\code{choice_formula}]\cr
A \code{\link{choice_formula}} object.}

\item{choice_alternatives}{[\code{choice_alternatives}]\cr
A \code{\link{choice_alternatives}} object.}

\item{choice_data}{[\code{NULL} | \code{choice_data}]\cr
A \code{\link{choice_data}} object.

Required to resolve data-dependent elements in \code{choice_formula} (if any).}

\item{delimiter}{[\code{character(1)}]\cr
The delimiter between covariate and alternative name.}

\item{x}{[\code{choice_effects}]\cr
The \code{choice_effects} object to be printed.}

\item{...}{Currently not used.}
}
\value{
A \code{choice_effects} object, which is a \code{data.frame}, where each row
is a model effect, and columns are
\enumerate{
\item \code{"effect_name"}, the name for the effect which is composed of
covariate and alternative name,
\item \code{"generic_name"}, the generic effect name \code{"beta_<effect number>"},
\item \code{"covariate"}, the (transformed) covariate name connected to the effect,
\item \code{"alternative"}, the alternative name connected to the effect (only
if the effect is alternative-specific),
\item \code{"as_covariate"}, indicator whether the covariate is alternative-specific,
\item \code{"as_effect"}, indicator whether the effect is alternative-specific,
\item \code{"mixing"}, a factor with levels in the order
\enumerate{
\item \code{"cn"} (correlated normal distribution),
}

indicating the type of random effect.
}

For identification, the choice effects are ordered according to the following
rules:
\enumerate{
\item Non-random effects come before random effects.
\item According to the ordering of the factor \code{mixing}.
\item Otherwise, the order is determined by occurrence in \code{formula}.
}

It contains the arguments \code{choice_formula}, \code{choice_alternatives}, and
\code{delimiter} as attributes.
}
\description{
This function constructs an object of class \code{choice_effects}, which
defines the effects of a choice model.
}
\examples{
choice_effects(
  choice_formula = choice_formula(
    formula = choice ~ price | income | I(comfort == 1),
    error_term = "probit",
    random_effects = c(
      "price" = "cn",
      "income" = "cn"
     )
  ),
  choice_alternatives = choice_alternatives(J = 3)
)
}
\keyword{model}
