% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_create.R
\name{cff_create}
\alias{cff_create}
\title{Create a \code{\link{cff}} object from several sources}
\usage{
cff_create(
  x,
  keys = list(),
  cff_version = "1.2.0",
  gh_keywords = TRUE,
  dependencies = TRUE,
  authors_roles = c("aut", "cre")
)
}
\arguments{
\item{x}{The source that would be used for generating
the \code{\link{cff}} object. It could be:
\itemize{
\item A missing value. That would retrieve the \code{DESCRIPTION} file on your
in-development \strong{R} package.
\item An existing \code{\link{cff}} object.
\item The name of an installed package (\code{"jsonlite"}).
\item Path to a \code{DESCRIPTION} file (\code{"./DESCRIPTION"}).
}}

\item{keys}{List of additional keys to add to the \code{\link{cff}} object. See
\code{\link[=cff_modify]{cff_modify()}}.}

\item{cff_version}{The Citation File Format schema version that the
\code{CITATION.cff} file adheres to for providing the citation metadata.}

\item{gh_keywords}{Logical \code{TRUE/FALSE}. If the package is hosted on
GitHub, would you like to add the repo topics as keywords?}

\item{dependencies}{Logical \code{TRUE/FALSE}. Would you like to add the
of your package to the \code{references} CFF key?}

\item{authors_roles}{Roles to be considered as authors of the package when
generating the \code{CITATION.cff} file. See \strong{Details}.}
}
\value{
A \code{\link{cff}} object.
}
\description{
Create a full and possibly valid \code{\link{cff}} object from a given source. This
object can be written to a \verb{*.cff } file with \code{\link[=cff_write]{cff_write()}},
see \strong{Examples}.

Most of the heavy lifting of \CRANpkg{cffr} is done via this function.
}
\details{
If \code{x} is a path to a \code{DESCRIPTION} file or \code{inst/CITATION}, is not present
on your package, \CRANpkg{cffr} would auto-generate a \code{preferred-citation}
key using the information provided on that file.

By default, only persons whose role in the \code{DESCRIPTION} file of the package
is author (\code{"aut"}) or maintainer (\code{"cre"}) are considered to be authors
of the package. The default setting can be controlled via the \code{authors_roles}
parameter. See \strong{Details} on \code{\link[=person]{person()}} to get additional insights
on person roles.
}
\examples{
\donttest{
# Installed package
cff_create("jsonlite")

# Demo file
demo_file <- system.file("examples/DESCRIPTION_basic", package = "cffr")
cff_create(demo_file)

# Add additional keys

newkeys <- list(
  message = "This overwrites fields",
  abstract = "New abstract",
  keywords = c("A", "new", "list", "of", "keywords"),
  authors = as_cff_person("New author")
)

cff_create(demo_file, keys = newkeys)

# Update a field on a list - i,e: authors, contacts, etc.
# We are adding a new contact here

old <- cff_create(demo_file)

new_contact <- append(
  old$contact,
  as_cff_person(person(
    given = "I am",
    family = "New Contact"
  ))
)


cff_create(demo_file, keys = list("contact" = new_contact))
}
}
\seealso{
\href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{Guide to Citation File Format schema version 1.2.0}.
\itemize{
\item \code{\link[=cff_modify]{cff_modify()}} as the recommended way to modify a \code{cff} object.
\item \code{\link[=cff_write]{cff_write()}} for creating a CFF file.
\item \code{vignette("cffr", "cffr")} shows an introduction on how manipulate
\code{cff} objects.
\item \code{vignette("crosswalk", package = "cffr")} provides details on how the
metadata of a package is mapped to produce a \code{cff} object.
}

Other core functions of \CRANpkg{cffr}:
\code{\link{cff}()},
\code{\link{cff_modify}()},
\code{\link{cff_validate}()}
}
\concept{core}
