% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind.sens.R
\name{ind.sens}
\alias{ind.sens}
\title{Sensitivity Analysis for Causal Decomposition with Individualized Interventions}
\usage{
ind.sens(k.y, k.m, Iternum, outcome, group, group.ref, intermediates, moderators,
  benchmark, risk.factor, covariates, data, B, cluster = NULL, nsim, mc.cores)
}
\arguments{
\item{k.y}{scales the association of the unmeasured confounder with the outcome
(numeric). A value of 1 means a one-unit change in the unmeasured confounder
shifts the mean of the outcome by the same amount as a one-unit change in the
benchmark covariate—conditional on the social-group indicator, intermediate
confounder(s), and baseline covariate(s). Default is 1.}

\item{k.m}{scales the association of the unmeasured confounder with the log-odds of
risk.factor = 1 (numeric). A value of 1 means a one-unit change in the unmeasured
confounder changes the log-odds of the risk factor by the same amount as the
benchmark covariate, conditional on the social-group indicator,
intermediate confounder(s), and baseline covariate(s). Default is 1.}

\item{Iternum}{Number of iterations in the stochastic EM algorithm for generating
the unmeasured confounder. default is 10.}

\item{outcome}{a character string indicating the name of the outcome.}

\item{group}{a character string indicating the name of the social group indicator
such as race or gender.}

\item{group.ref}{reference group of the social group indicator.}

\item{intermediates}{vector containing the name of intermediate confounders.}

\item{moderators}{a character string indicating the name of variables that have
heterogeneous effects on the outcome based on the risk factor.}

\item{benchmark}{a vector containing the name of the benchmark covariate used to
scale k.y and k.m.}

\item{risk.factor}{a character string indicating the name of the risk factor.}

\item{covariates}{a vector containing the name of baseline covariate variable(s).}

\item{data}{The data set for analysis (data.frame).}

\item{B}{Number of bootstrapped samples in the causal decomposition analysis.}

\item{cluster}{a vector of cluster indicators for the bootstrap. If provided,
the cluster bootstrap is used. Default is 'NULL'.}

\item{nsim}{Number of random draws of the unmeasured confounder per observation.
default is 15. Increase the number for more smooth curves.}

\item{mc.cores}{Number of cores to use. Must be exactly 1 on Windows. Default is 1.}
}
\value{
A matrix containing the adjusted point estimates for:
\enumerate{
\item the initial disparity, the proportion recommended for treatment,
\item the disparity remaining and percent reduction based on individualized conditional effects,
\item the disparity remaining, disparity reduction, and percent reduction based on individualized
intervention effects.
}
It also returns the adjusted nonparametric bootstrap confidence intervals for each estimate.
}
\description{
‘ind.sens’ is used to assess the sensitivity of estimates from the
individualized causal decomposition to potential omitted confoudners between
the risk factor M and the outcome Y, using a benchmarking approach based on
the relative strength of an unmeasured confounder compared to a specified
covariate. The function employs a stochastic EM algorithm to simulate the
distribution of the unobserved confounder and generate bias-adjusted estimates.
}
\details{
This function returns the adjusted point estimates and confidence intervals
after accounting for a simulated unmeasured confounder \eqn{U}. We employ an approach
that compares the coefficient of the unmeasured confounder \eqn{U} with that of an
observed covariate \eqn{X_j}, after controlling for the remaining observed covariates
(\eqn{R}, \eqn{X_{-j}}, and \eqn{C}).

Specifically, \eqn{k_y} indicates
the extent to which the outcome \eqn{Y} is associated with a one unit increase in
\eqn{U} relative to how much it is associated with a one unit change in \eqn{X_j},
after controlling for \eqn{R}, \eqn{X_{-j}}, and \eqn{C}. Likewise, \eqn{k_m} indicates the extent
to which the odds of \eqn{M = 1} are explained by unmeasured confounder \eqn{U} relative to
how much they are explained by \eqn{X_j}, after controlling for \eqn{R}, \eqn{X_{-j}}, and \eqn{C}.
These parameters (\eqn{k_m} and \eqn{k_y}) should be specified by researchers based on the
assumed strength of \eqn{U} relative to that of the given observed covariate \eqn{X_j}.
}
\examples{
data(idata)

\donttest{results_adj <- ind.sens(k.y = 1, k.m = 1, Iternum = 5, outcome = "Y", group = "R", group.ref = "0",
                       intermediates = c("X1", "X2", "X3"), moderators = c("X1", "X2"),
                       benchmark = "X1", risk.factor = "M", covariates = "C", data = idata,
                       B = 50, cluster = NULL, nsim = 10, mc.cores = 1)
results_adj}
}
\references{
Park, S., Kang, S., & Lee, C. (2025). Simulation-Based Sensitivity Analysis in
Optimal Treatment Regimes and Causal Decomposition with Individualized Interventions.
arXiv preprint arXiv:2506.19010.
}
\seealso{
\code{\link{ind.decomp}}
}
\author{
Soojin Park, University of California, Riverside, \email{soojinp@ucr.edu};
Suyeon Kang, University of Central Florida, \email{suyeon.kang@ucf.edu};
Karen Xu, University of California, Riverside, \email{karenxu@ucr.edu}.
}
