% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{districts}
\alias{districts}
\title{Get districts (c-components) of an ADMG}
\usage{
districts(cg)
}
\arguments{
\item{cg}{A \code{caugi} object of class ADMG.}
}
\value{
A list of character vectors,
each containing the nodes in a district.
}
\description{
Get the districts (c-components) of an ADMG.
A district is a maximal set of nodes connected via bidirected edges.
}
\examples{
cg <- caugi(
  A \%-->\% B,
  A \%<->\% C,
  D \%<->\% E,
  class = "ADMG"
)
districts(cg)
# Returns list with districts: {A, C}, {B}, {D, E}

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
