% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocov.R
\encoding{UTF-8}
\name{madperm}
\alias{madperm}
\title{Permutation tests for CATA data}
\usage{
madperm(X, B = 99, seed = .Random.seed, tests = 1:5, alpha = 0.05, control.fdr = FALSE, 
verbose = FALSE)
}
\arguments{
\item{X}{a three-way (or four-way) array with \eqn{I} assessors, 
(\eqn{R} conditions/timepoints,) \eqn{P} products, \eqn{T} terms with data valued 
\code{0} (not checked) and \code{1} (checked)}

\item{B}{permutations in null distribution; ensure \code{B} is
larger than the default value (\code{99}) when conducting real analyses}

\item{seed}{specify a numeric seed for reproducibility; if not provided, a random 
seed is generated}

\item{tests}{numeric vector specifying which tests to conduct; default 
\code{1:5} (all tests): (\code{1}) multivariate (global) test; (\code{2}) univariate tests; 
(\code{3}) elementwise tests; (\code{4}) pairwise multivariate tests; (\code{5}) 
pairwise univariate tests}

\item{alpha}{Type I error rate (default: \eqn{\alpha} = \code{0.05})}

\item{control.fdr}{control False Discovery Rate (using Benjamini-Hochberg (BH) step-up 
procedure)? (default: \code{FALSE})}

\item{verbose}{return null distribution(s) and function call? (default: \code{FALSE})}
}
\value{
list, one per condition:
\itemize{
\item{\code{CATA.table} : table of CATA citation percentages (\eqn{P \times T})}
\item{\code{CATA.freq} : CATA frequency table (\eqn{P \times T})}
\item{Permutation test results specified by the \code{tests} parameter
\enumerate{
\item{\code{Global.Results} : list of multivariate (global) results}
\item{\code{Univariate.Results} : list of \eqn{T} univariate results}
\item{\code{Elementwise.Results} : list of \eqn{PT} elementwise results}
\item{\code{Multivariate.Paired.Results} : list of \eqn{P(P-1)/2} multivariate paired results}
\item{\code{Univariate.Paired.Results} : list of \eqn{P(P-1)T/2} univariate paired results} }}}
also, if \code{verbose} is \code{TRUE}:
\itemize{
\item{\code{Null.Dist} list of null distributions for tests specified}
\item{\code{Call} : \code{madperm} function call}}
}
\description{
Permutation tests for check-all-that-apply (CATA) data following the 
'one citation, one vote' principle. Returns CATA frequency and percentage tables per 
condition and permutation test results specified.
}
\examples{
# add product names
X <- bread$cata[1:100,,1:5]
dimnames(X)[[2]] <- paste0("P", dimnames(X)[[2]])
# permutation tests for the first 100 consumers and 5 attributes
# will be run with default parameter values for illustrative purposes only
res <- madperm(X, B = 99, seed = 123)
print(res) # inspect results
}
\references{
Chaya, C., Castura, J.C., & Greenacre, M.J. (2025). One citation, one vote! 
A new approach for analyzing check-all-that-apply (CATA) data 
using L1 norm methods. \emph{Food Quality and Preference}, 134, 105639, 
\doi{10.1016/j.foodqual.2018.09.006}
}
\author{
J.C. Castura
}
