% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stack_hierarchical.R
\name{ard_stack_hierarchical}
\alias{ard_stack_hierarchical}
\alias{ard_stack_hierarchical_count}
\title{Stacked Hierarchical ARD Statistics}
\usage{
ard_stack_hierarchical(
  data,
  variables,
  by = dplyr::group_vars(data),
  id,
  denominator,
  include = everything(),
  statistic = everything() ~ c("n", "N", "p"),
  overall = FALSE,
  over_variables = FALSE,
  attributes = FALSE,
  total_n = FALSE,
  shuffle = FALSE,
  by_stats = TRUE
)

ard_stack_hierarchical_count(
  data,
  variables,
  by = dplyr::group_vars(data),
  denominator = NULL,
  include = everything(),
  overall = FALSE,
  over_variables = FALSE,
  attributes = FALSE,
  total_n = FALSE,
  shuffle = FALSE,
  by_stats = TRUE
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Specifies the nested/hierarchical structure of the data.
The variables that are specified here and in the \code{include} argument
will have summary statistics calculated.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
variables to perform tabulations by. All combinations of the variables
specified here appear in results. Default is \code{dplyr::group_vars(data)}.}

\item{id}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
argument used to subset \code{data} to identify rows in \code{data} to calculate
event rates in \code{ard_stack_hierarchical()}. See details below.}

\item{denominator}{(\code{data.frame}, \code{integer})\cr
used to define the denominator and enhance the output.
The argument is required for \code{ard_stack_hierarchical()} and optional
for \code{ard_stack_hierarchical_count()}.
\itemize{
\item the univariate tabulations of the \code{by} variables are calculated with \code{denominator},
when a data frame is passed, e.g. tabulation of the treatment assignment
counts that may appear in the header of a table.
\item the \code{denominator} argument must be specified when \code{id} is used to
calculate the event rates.
\item if \code{total_n=TRUE}, the \code{denominator} argument is used to return the total N
}}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Specify the subset a columns indicated in the \code{variables} argument for which
summary statistics will be returned. Default is \code{everything()}.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element one or more of  \code{c("n", "N", "p", "n_cum", "p_cum")}
(on the RHS of a formula).}

\item{overall}{(scalar \code{logical})\cr logical indicating whether overall statistics
should be calculated (i.e. repeat the operations with \code{by=NULL} in \emph{most cases}, see below for details).
Default is \code{FALSE}.}

\item{over_variables}{(scalar \code{logical})\cr
logical indicating whether summary statistics
should be calculated over or across the columns listed in the \code{variables} argument.
Default is \code{FALSE}.}

\item{attributes}{(scalar \code{logical})\cr
logical indicating whether to include the results of \code{ard_attributes()} for all
variables represented in the ARD. Default is \code{FALSE}.}

\item{total_n}{(scalar \code{logical})\cr
logical indicating whether to include of \code{ard_total_n(denominator)} in the returned ARD.}

\item{shuffle}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} support for \code{.shuffle = TRUE}
will be removed in the next release. \code{ard_stack_hierarchical()} and
\code{ard_stack_hierarchical_count()} will no longer shuffle. \code{shuffle_ard()}
should be called separately.}

\item{by_stats}{(\code{logical})\cr
logical indicating whether to include overall stats of the \code{by} variables in the returned ARD.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Use these functions to calculate multiple summaries of nested or hierarchical data
in a single call.
\itemize{
\item \code{ard_stack_hierarchical()}: Calculates \emph{rates} of events (e.g. adverse events)
utilizing the \code{denominator} and \code{id} arguments to identify the rows in \code{data}
to include in each rate calculation.
\item \code{ard_stack_hierarchical_count()}: Calculates \emph{counts} of events utilizing
all rows for each tabulation.
}
}
\section{Subsetting Data for Rate Calculations}{


To calculate event rates, the \code{ard_stack_hierarchical()} function identifies
rows to include in the calculation.
First, the primary data frame is sorted by the columns identified in
the \code{id}, \code{by}, and \code{variables} arguments.

As the function cycles over the variables specified in the \code{variables} argument,
the data frame is grouped by \code{id}, \code{intersect(by, names(denominator))}, and \code{variables}
utilizing the last row within each of the groups.

For example, if the call is
\code{ard_stack_hierarchical(data = ADAE, variables = c(AESOC, AEDECOD), id = USUBJID)},
then we'd first subset ADAE to be one row within the grouping \code{c(USUBJID, AESOC, AEDECOD)}
to calculate the event rates in \code{'AEDECOD'}. We'd then repeat and
subset ADAE to be one row within the grouping \code{c(USUBJID, AESOC)}
to calculate the event rates in \code{'AESOC'}.
}

\section{Overall Argument}{

When we set \code{overall=TRUE}, we wish to re-run our calculations removing the
stratifying columns. For example, if we ran the code below, we results would
include results with the code chunk being re-run with \code{by=NULL}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ard_stack_hierarchical(
  data = ADAE,
  variables = c(AESOC, AEDECOD),
  by = TRTA,
  denominator = ADSL,
  id = USUBJID,
  overall = TRUE
)
}\if{html}{\out{</div>}}

But there is another case to be aware of: when the \code{by} argument includes
columns that are not present in the \code{denominator}, for example when tabulating
results by AE grade or severity in addition to treatment assignment.
In the example below, we're tabulating results by treatment assignment and
AE severity. By specifying \code{overall=TRUE}, we will re-run the to get
results with \code{by = AESEV} and again with \code{by = NULL}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ard_stack_hierarchical(
  data = ADAE,
  variables = c(AESOC, AEDECOD),
  by = c(TRTA, AESEV),
  denominator = ADSL,
  id = USUBJID,
  overall = TRUE
)
}\if{html}{\out{</div>}}
}

\examples{
ard_stack_hierarchical(
  ADAE,
  variables = c(AESOC, AEDECOD),
  by = TRTA,
  denominator = ADSL,
  id = USUBJID
)

ard_stack_hierarchical_count(
  ADAE,
  variables = c(AESOC, AEDECOD),
  by = TRTA,
  denominator = ADSL
)
}
