% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-forecast.R
\name{mape}
\alias{mape}
\alias{mape.predbvhar}
\alias{mape.bvharcv}
\title{Evaluate the Model Based on MAPE (Mean Absolute Percentage Error)}
\usage{
mape(x, y, ...)

\method{mape}{predbvhar}(x, y, ...)

\method{mape}{bvharcv}(x, y, ...)
}
\arguments{
\item{x}{Forecasting object}

\item{y}{Test data to be compared. should be the same format with the train data.}

\item{...}{not used}
}
\value{
MAPE vector corresponding to each variable.
}
\description{
This function computes MAPE given prediction result versus evaluation set.
}
\details{
Let \eqn{e_t = y_t - \hat{y}_t}.
Percentage error is defined by \eqn{p_t = 100 e_t / Y_t} (100 can be omitted since comparison is the focus).

\deqn{MAPE = mean(\lvert p_t \rvert)}
}
\references{
Hyndman, R. J., & Koehler, A. B. (2006). \emph{Another look at measures of forecast accuracy}. International Journal of Forecasting, 22(4), 679-688.
}
