% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_autobahn.R
\name{autobahn_warning_details}
\alias{autobahn_warning_details}
\title{Get Autobahn warning details}
\usage{
autobahn_warning_details(warning_id, flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{warning_id}{Warning identifier.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with warning details.
}
\description{
Get Autobahn warning details
}
\details{
Returns full details for a single warning entry.
Official docs: https://autobahn.api.bund.dev.
}
\examples{
\dontrun{
roads <- autobahn_roads()
warnings <- autobahn_warnings(roads$road_id[[1]])
autobahn_warning_details(warnings$identifier[[1]])
}
}
\seealso{
\code{\link[=autobahn_warnings]{autobahn_warnings()}} to list warnings.
}
