% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btw_this.R
\name{btw_this.character}
\alias{btw_this.character}
\title{Describe objects}
\usage{
\method{btw_this}{character}(x, ..., caller_env = parent.frame())
}
\arguments{
\item{x}{A character string}

\item{...}{Ignored.}

\item{caller_env}{The caller environment.}
}
\value{
A character vector of lines describing the object.
}
\description{
Character strings in \code{btw_this()} are used as shortcuts to many underlying
methods. \code{btw_this()} detects specific formats in the input string to
determine which method to call, or by default it will try to evaluate the
character string as R code and return the appropriate object description.

\code{btw_this()} knows about the following special character string formats:
\itemize{
\item \code{"./path"} \cr
Any string starting with \verb{./} is treated as a relative path.
If the path is a file, we call \code{\link[=btw_tool_files_read_text_file]{btw_tool_files_read_text_file()}} and if the path
is a directory we call \code{\link[=btw_tool_files_list_files]{btw_tool_files_list_files()}} on the path.
\itemize{
\item \code{btw_this("./data")} lists the files in \verb{data/}.
\item \code{btw_this("./R/load_data.R")} reads the source of the \code{R/load_data.R}
file.
}
\item \code{"{pkgName}"} or \code{"@pkg pkgName"} \cr
A package name wrapped in braces, or using the \verb{@pkg} command. Returns the
list of help topics (\code{\link[=btw_tool_docs_package_help_topics]{btw_tool_docs_package_help_topics()}}) and, if it
exists, the introductory vignette for the package (\code{\link[=btw_tool_docs_vignette]{btw_tool_docs_vignette()}}).
\itemize{
\item \code{btw_this("{dplyr}")} or \code{btw_this("@pkg dplyr")} includes dplyr's introductory vignette.
\item \code{btw_this("{btw}")} returns only the package help index (because \code{btw}
doesn't have an intro vignette, yet).
}
\item \code{"?help_topic"} or \code{"@help topic"} \cr
When the string starts with \verb{?} or \verb{@help}, btw searches R's help
topics using \code{\link[=btw_tool_docs_help_page]{btw_tool_docs_help_page()}}. Supports multiple formats:
\itemize{
\item \code{btw_this("?dplyr::across")} or \code{btw_this("@help dplyr::across")}
\item \code{btw_this("@help dplyr across")} - space-separated format
\item \code{btw_this("@help across")} - searches all packages
}
\item \code{"@news {{package_name}} {{search_term}}"} \cr
Include the release notes (NEWS) from the latest package release, e.g.
\code{"@news dplyr"}, or that match a search term, e.g. \code{"@news dplyr join_by"}.
\item \code{"@url {{url}}"} \cr
Include the contents of a web page at the specified URL as markdown, e.g.
\code{"@url https://cran.r-project.org/doc/FAQ/R-FAQ.html"}. Requires the
\pkg{chromote} package to be installed.
\item \code{"@git status"}, \code{"@git diff"}, \code{"@git log"} \cr
Git commands for viewing repository status, diffs, and commit history.
Requires \pkg{gert} package and a git repository.
\itemize{
\item \code{btw_this("@git status")} - show working directory status
\item \code{btw_this("@git status staged")} - show only staged files
\item \code{btw_this("@git diff")} - show unstaged changes
\item \code{btw_this("@git diff HEAD")} - show staged changes
\item \code{btw_this("@git log")} - show recent commits (default 10)
\item \code{btw_this("@git log main 20")} - show 20 commits from main branch
}
\item \code{"@issue #number"} or \code{"@pr #number"} \cr
Fetch a GitHub issue or pull request. Automatically detects the current
repository, or you can specify \code{owner/repo#number} or \verb{owner/repo number}.
Requires \pkg{gh} package and GitHub authentication.
\itemize{
\item \code{btw_this("@issue #65")} - issue from current repo
\item \code{btw_this("@pr posit-dev/btw#64")} - PR from specific repo
\item \code{btw_this("@issue tidyverse/dplyr 1234")} - space-separated format
}
\item \code{"@current_file"} or \code{"@current_selection"} \cr
When used in RStudio or Positron, or anywhere else that the
\pkg{rstudioapi} is supported, \code{btw("@current_file")} includes the contents
of the file currently open in the editor using
\code{\link[rstudioapi:rstudio-editors]{rstudioapi::getSourceEditorContext()}}.
\item \code{"@clipboard"} \cr
Includes the contents currently stored in your clipboard.
\item \code{"@platform_info"} \cr
Includes information about the current platform, such as the R version,
operating system, IDE or UI being used, as well as language, locale,
timezone and current date.
\item \code{"@attached_packages"}, \code{"@loaded_packages"}, \code{"@installed_packages"} \cr
Includes information about the attached, loaded, or installed packages in
your R session, using \code{\link[sessioninfo:package_info]{sessioninfo::package_info()}}.
\item \code{"@last_error"} \cr
Includes the message from the last error that occurred in your session.
To reliably capture the last error, you need to enable
\code{\link[rlang:global_entrace]{rlang::global_entrace()}} in your session.
\item \code{"@last_value"} \cr
Includes the \code{.Last.value}, i.e. the result of the last expression
evaluated in your R console.
}
}
\examples{
mtcars[1:3, 1:4]
cat(btw_this("@last_value"))

}
\seealso{
Other btw formatting methods: 
\code{\link{btw_this}()},
\code{\link{btw_this.data.frame}()},
\code{\link{btw_this.environment}()}
}
\concept{btw formatting methods}
