% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_buffers.R
\name{add_buffers}
\alias{add_buffers}
\title{Add buffers to an existing design}
\usage{
add_buffers(design_obj, type)
}
\arguments{
\item{design_obj}{A design object (with class "design") from the design() function}

\item{type}{The type of buffer to add. One of 'edge', 'row', 'column', 'double row', or 'double column'.}
}
\value{
The modified design object with buffers added
}
\description{
Add buffers to an existing design
}
\examples{
# Create a simple CRD design
des <- design(type = "crd", treatments = c("A", "B"), reps = 3, nrows = 2, ncols = 3, seed = 42)

# Plot the original design
autoplot(des)

# Add edge buffers to the design
des_buf <- add_buffers(des, type = "edge")

# Plot the design with buffers
autoplot(des_buf)

# Add double row buffers
des_row_buf <- add_buffers(des, type = "double row")
autoplot(des_row_buf)

}
