% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_predict.R
\name{predict.bgmCompare}
\alias{predict.bgmCompare}
\title{Predict Conditional Probabilities from a Fitted bgmCompare Model}
\usage{
\method{predict}{bgmCompare}(
  object,
  newdata,
  group,
  variables = NULL,
  type = c("probabilities", "response"),
  method = c("posterior-mean"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{bgmCompare}.}

\item{newdata}{A matrix or data frame with \code{n} rows and \code{p} columns
containing the observed data. Must have the same variables (columns) as
the original data used to fit the model.}

\item{group}{Integer specifying which group's parameters to use for
prediction (1 to number of groups). Required argument.}

\item{variables}{Which variables to predict. Can be:
\itemize{
  \item A character vector of variable names
  \item An integer vector of column indices
  \item \code{NULL} (default) to predict all variables
}}

\item{type}{Character string specifying the type of prediction:
\describe{
  \item{\code{"probabilities"}}{Return the full conditional probability
    distribution for each variable and observation.}
  \item{\code{"response"}}{Return the predicted category (mode of the
    conditional distribution).}
}}

\item{method}{Character string specifying which parameter estimates to use:
\describe{
  \item{\code{"posterior-mean"}}{Use posterior mean parameters.}
}}

\item{...}{Additional arguments (currently ignored).}
}
\value{
For \code{type = "probabilities"}: A named list with one element per
predicted variable. Each element is a matrix with \code{n} rows and
\code{num_categories + 1} columns containing \eqn{P(X_j = c | X_{-j})}{P(X_j = c | X_-j)}
for each observation and category.

For \code{type = "response"}: A matrix with \code{n} rows and
\code{length(variables)} columns containing predicted categories.
}
\description{
Computes conditional probability distributions for one or more variables
given the observed values of other variables in the data, using
group-specific parameters from a \code{bgmCompare} model.
}
\details{
Group-specific parameters are obtained by applying the projection matrix
to convert baseline parameters and differences into group-level estimates.
The function then computes the conditional distribution of target variables
given the observed values of all other variables.
}
\examples{
\donttest{
# Fit a comparison model
x <- Boredom[Boredom$language == "fr", 2:6]
y <- Boredom[Boredom$language != "fr", 2:6]
fit <- bgmCompare(x, y, chains = 2)

# Predict conditional probabilities using group 1 parameters
probs_g1 <- predict(fit, newdata = x[1:10, ], group = 1)

# Predict responses using group 2 parameters
pred_g2 <- predict(fit, newdata = y[1:10, ], group = 2, type = "response")
}

}
\seealso{
\code{\link{predict.bgms}} for predicting from single-group models,
  \code{\link{simulate.bgmCompare}} for simulating from group-comparison models.
}
