% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{shannon}
\alias{shannon}
\title{Shannon's Index or Entropy}
\usage{
shannon(taxon, count, base = 2)
}
\arguments{
\item{taxon}{taxa names (\code{character})}

\item{count}{counts (\code{numeric})}

\item{base}{the base with respect to which logarithms are computed.
Defaults to 2 (unit: bits).}
}
\value{
Shannon's entropy
}
\description{
Compute entropy according to Shannon (1948)
}
\examples{
 shannon(
     taxon = c("Euspira pulchella", "Nephtys cirrosa"),
     count = c(4, 6)
 )

}
\references{
Shannon, C. E., 1948. A Mathematical Theory of Communication.
     Bell System Technical Journal 27: 379-423.
}
